<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:variable name="uniqueOffsetAlignment" select="//StationOffsetPoints/StationOffsetPoint[not (@offsetAlignmentName = preceding-sibling::StationOffsetPoint/@offsetAlignmentName)]/@offsetAlignmentName"/>
    <xsl:variable name="totalArea" select="0"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis Výškový rozdíl</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis Výškový rozdíl</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@description"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@file"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <table class="margin" cellpadding="2" width="80%">
                                    <xsl:for-each select="HorizontalAlignment[StationOffsetPoints]">
                                        <thead style="display:table-header-group">
                                            <tr>
                                                <td colspan="5" lang="en">
                                                    <strong>&#xa0; &#xa0; &#xa0; &#xa0; &#xa0;Trasa Název:&#xa0; </strong>
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="5" lang="en">
                                                    <strong>Trasa Popis:&#xa0; </strong>
                                                    <xsl:value-of select="@description"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="5" lang="en">
                                                    <strong>&#xa0; &#xa0; &#xa0; &#xa0; &#xa0; &#xa0;Trasa Styl:&#xa0; </strong>
                                                    <xsl:value-of select="@style"/>
                                                    <br/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="5">&#xa0;</td>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en" valign="bottom">Staničení</th>
                                                <th class="underline" lang="en" valign="bottom">
                                                    Z <br/>Prvek 1<br/>
                                                    (<xsl:value-of select="$uniqueOffsetAlignment[1]"/>)
                                                </th>
                                                <th class="underline" lang="en" valign="bottom">
                                                    Z <br/>Prvek 2<br/>
                                                    (<xsl:value-of select="$uniqueOffsetAlignment[2]"/>)
                                                </th>
                                                <th class="underline" lang="en" valign="bottom">Rozdíl</th>
                                                <th class="underline" lang="en" valign="bottom">Plocha</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <xsl:for-each select="StationOffsetPoints/StationOffsetPoint[@offsetAlignmentName = $uniqueOffsetAlignment[1]]">
                                                <xsl:variable name="curStation" select="centerLinePoint/point/station/@externalStation"/>
                                                <xsl:variable name="curFtr1Elev" select="offsetLinePoint/point/@elevation"/>
                                                <xsl:variable name="curFtr2Elev" select="//StationOffsetPoint[@offsetAlignmentName = $uniqueOffsetAlignment[2] and centerLinePoint/point/station/@externalStation = current()/centerLinePoint/point/station/@externalStation]/offsetLinePoint/point/@elevation"/>
                                                <xsl:variable name="curDiff" select="$curFtr2Elev - $curFtr1Elev"/>
                                                <tr>
                                                    <td class="sidepad" align="right" nowrap="nowrap">
                                                        <xsl:value-of select="cif:stationFormat(number($curStation), string(centerLinePoint/point/station/@externalStationName))"/>
                                                    </td>
                                                    <td class="sidepad" align="right">
                                                        <xsl:value-of select="cif:ordinateFormat(number($curFtr1Elev))"/>
                                                    </td>
                                                    <td class="sidepad" align="right">
                                                        <xsl:value-of select="cif:ordinateFormat(number($curFtr2Elev))"/>
                                                    </td>
                                                    <td class="sidepad" align="right">
                                                        <xsl:value-of select="cif:ordinateFormat(number($curDiff))"/>
                                                    </td>
                                                    <xsl:choose>
                                                        <xsl:when test="position() = 1">
                                                            <td class="sidepad" align="center">---</td>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:variable name="prvStation" select="preceding-sibling::*[1]/centerLinePoint/point/station/@externalStation"/>
                                                            <xsl:variable name="prvFtr1Elev" select="preceding-sibling::*[1]/offsetLinePoint/point/@elevation"/>
                                                            <xsl:variable name="prvFtr2Elev" select="//StationOffsetPoint[@offsetAlignmentName = $uniqueOffsetAlignment[2] and centerLinePoint/point/station/@externalStation = current()/preceding-sibling::*[1]/centerLinePoint/point/station/@externalStation]/offsetLinePoint/point/@elevation"/>
                                                            <xsl:variable name="prvDiff" select="$prvFtr2Elev - $prvFtr1Elev"/>
                                                            <xsl:variable name="areaFace" select="(($curDiff + $prvDiff) div 2) * ($curStation - $prvStation)"/>
                                                            <td class="sidepad" align="right">
                                                                <xsl:value-of select="cif:areaFormat(number($areaFace))"/>
                                                            </td>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </tr>
                                            </xsl:for-each>
                                            <tr>
                                                <td class="sidepad" colspan="5">
                                                    <hr size="1"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th class="sidepad" align="right" colspan="4" lang="en">Celkem:&#xa0; </th>
                                                <td class="sidepad" align="right">
                                                    <xsl:variable name="faceAreas">
                                                        <xsl:for-each select="//StationOffsetPoints/StationOffsetPoint[@offsetAlignmentName = $uniqueOffsetAlignment[1]]">
                                                            <xsl:choose>
                                                                <xsl:when test="position() = 1"/>
                                                                <xsl:otherwise>
                                                                    <xsl:variable name="curStation" select="centerLinePoint/point/station/@externalStation"/>
                                                                    <xsl:variable name="curFtr1Elev" select="offsetLinePoint/point/@elevation"/>
                                                                    <xsl:variable name="curFtr2Elev" select="//StationOffsetPoint[@offsetAlignmentName = $uniqueOffsetAlignment[2] and centerLinePoint/point/station/@externalStation = current()/centerLinePoint/point/station/@externalStation]/offsetLinePoint/point/@elevation"/>
                                                                    <xsl:variable name="curDiff" select="$curFtr2Elev - $curFtr1Elev"/>
                                                                    <xsl:variable name="prvStation" select="preceding-sibling::*[1]/centerLinePoint/point/station/@externalStation"/>
                                                                    <xsl:variable name="prvFtr1Elev" select="preceding-sibling::*[1]/offsetLinePoint/point/@elevation"/>
                                                                    <xsl:variable name="prvFtr2Elev" select="//StationOffsetPoint[@offsetAlignmentName = $uniqueOffsetAlignment[2] and centerLinePoint/point/station/@externalStation = current()/preceding-sibling::*[1]/centerLinePoint/point/station/@externalStation]/offsetLinePoint/point/@elevation"/>
                                                                    <xsl:variable name="prvDiff" select="$prvFtr2Elev - $prvFtr1Elev"/>
                                                                    <number>
                                                                        <xsl:value-of select="(($curDiff + $prvDiff) div 2) * ($curStation - $prvStation)"/>
                                                                    </number>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </xsl:for-each>
                                                    </xsl:variable>
                                                    <xsl:value-of select="cif:areaFormat(number(sum(msxsl:node-set($faceAreas)/number)))"/>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Tento výpis bude mít nejlepší výsledky pro výpis s jednou základní trasou (nebo prvkem) a dvěma prvky v odstupu, 
                v intervalu definovaném uživatelem.&#xa0; Další XML data nemusí dávat uspokojivé výsledky.
            </p>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vytvořit body v odstupu pomocí <em>
                Nástroje &gt; XML Výpisy &gt; Základní staničení </em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jedno směrové řešení nebo jeden prvek v listu <em>Obecně</em> <em>Z</em>.&#xa0; 
				Musíte také vybrat dva prvky v listu <em>Prvky</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu volbu v listu <em>Zahrnout</em> (<em>
                    Směrové body - Na trase, Významné, 
					Výškové body - Na trase, Významné
                </em> nebo <em>Interval</em>.)
            </p>
            <p class="normal1" lang="en">
                <em>Staničení Limity</em>použijte pouze na spočtená data, např. body pomocí Interval.
            </p>
            <p class="normal1" lang="en">
                Je velmi důležité, aby měly dva prvky v odstupu data v každém staničení.&#xa0; 
				Pokud budou data na některém chybět, bude zobrazeno <em>NaN</em> (Není číslo - Not a Number).&#xa0; 
				Pokud není některá hodnota číslo, nebude správný ani součet a bude zobrazeno opět <em>NaN</em>.&#xa0; 
				Nejjednodušší způsob opravy chybného staničení je vyhledání bodu v daném staničení pomocí      
                <code>centerLinePoint/point/station/@externalStation</code> a jeho smazání ze XML souboru.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2013 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
